#!/bin/bash

# =============  FUNCTIONS ==============

#  get index if value in list
function get_rep_rate_index()
{
    value=$1
    my_rep_rates=$2
    rep_rate_list=$(echo "${my_rep_rates[@]}")
    
    # return index counter
    counter=0

    for i in `eval echo ${rep_rate_list[@]}`; do
    
        if [[ "$i" = "${value}" ]]; then
        
            # return this value
            echo $counter
            
            # no stop the loops
            return
        fi
        
        # increment counter
        counter=$((counter+1))
    
    done
}

#  set distances based on number of clients
function set_client_distance()
{
    nClients=$1
    nLTEclients=$2

    # echo "lte_clients" $nLTEclients
    # echo "num_clients" $nClients

    # update the distances for the streaming clients
    for i in `eval echo {0..$(($nClients - 1 ))}`; do

        newDistances[$i]=`echo "scale=0; 25.0 + $i*350/$((nClients-1))" | bc` 

    done

    # if the number of clients and LTE clients are not the same, update some additional distances
    if [[ "$nLTEclients" -ne "${nClients}" ]]; then

        for i in `eval echo {$nClients..$(($nLTEclients - 1 ))}`; do

            newDistances[$i]=1.0
        done

    fi

    echo ${newDistances[@]}
}
