#!/bin/bash

# This file is conversionScript.sh
# jason quinlan - j.quinlan@cs.ucc.ie - 25th November 2015 - v1.0

# This is a bash script for determining the byte cost per segment for each representation

# bitrates to use
# indexs from 0 to 8, not 1 to 9
ourbitrates=(6000 5000 4000 3000 2500 2000 1500 1000 500)
bitrateList=${ourbitrates[@]}

# change this for output file duration
filePost=16min

# fps
myfps=24

# counter - use value 0 for all iterations, use value 4 for testing script
COUNTER=0
byteCostCounter=0

# DASH segment size - number of seconds in milliseconds - 4-seconds defines 4000 millisec
num_sec=4
chunk_size=$(( $num_sec * 1000  ))

# folder variables
script_file_location="Script_Files"
awk_script_location="${script_file_location}/awk_scripts"
gnuplot_script_location="${script_file_location}/gnuplot_scripts"
printLines="false"

run=1

# file output format
file_format="Columned_Client_Ouput_test"

# ************* INPUT VALUES ***************
# $outputFolderName -
outputFolderName=$1
# $outputFile -
outputFile=$2
# $algoName - algorithm
algoName=$3
# $streamSegNum - number of Segments
streamSegNum=$4
# ${folderDASH[$urlCounter]} -
clipName=$5
# $((clientCounter)) -
clientCounter=$6
# ${scenFolder}
scenFolder=$7


# ************* ITEMS TO CHANGE ***************
# clip name
folders=($clipName)
# video encoder
encoder=x264
# bandwidth over mininet bottleneck
bottleBandwidths=(5)

# remove the old columnised trace file
rm ~/Desktop/${file_format}${clientCounter}.txt


for bottleBandwidth in "${bottleBandwidths[@]}"
do
    # counter
    fileCounter=0

    for folderName in "${folders[@]}"
    do

# echo $bottleBandwidth
# echo $folderName
# echo $clientCounter
# echo $outputFolder
# echo $streamSegNum
# echo $folderName

        # ****** BEGIN HERE ******

	# extract the adaptation, a number of clients, from the Chrome console log
        awk -v a="${clientCounter}" -v b=${outputFolder} -v c="$streamSegNum" -v clip=${folderName} -v bitRateList="$bitrateList" -v printOut="$printLines" -f ${awk_script_location}/MP4Client_column_output.awk ./$scenFolder/$outputFolderName/$outputFile > ./$scenFolder/$outputFolderName/${file_format}${clientCounter}.txt

        echo "finished"

    done

done

cp ./$scenFolder/$outputFolderName/${file_format}${clientCounter}.txt ~/Desktop/${file_format}${clientCounter}.txt
