#!/bin/bash

# This file is DASH_MP4Client_script.sh
# jason quinlan - j.quinlan@cs.ucc.ie - 25th November 2015 - v2.3

# This is a bash script for starting a number of GPAC MP4Clients, and within each GUI, we will view a different DASH stream using MP4CLient

# This is called using:
# DASH_MP4Client_script.sh <ExpFolder> <clientId> <urlNumber> <streamSegNum> <algoName> <bandwidth> <gpacCommand>
# ExpFolder -> scenario folder
# clientId -> number from 1 upwards
# urlNumber -> number from 0 upwards
# streamSegNum -> number from 0 upwards, with 0 denoting and any value > 0 = # of segments to download
# algoName -> algorithm name to use, choices are: 
# bandwidth -> number from 0 upwards
# gpacCommand -> 

# see what has been passed in
if [ $# -eq 0 ]
  then
    # ExpFolder folder
    scenFolder="."
    # number of clients
    clientCounter=1
    # clip to use
    urlCounter=0
    # number of segments to stream
    streamSegNum=7;
    # algorithm to use
    algoName=default;
    # video output to use
    videoDriver="X11"
	# segment duration length in seconds
	playValue=2
    # bandwidth - pacing level
    pacingBandwidth=5
    # extra GPAC commands
    gpacCommand=""
    echo "Setting default values for all - scenario folder to $scenFolder client number to $clientCounter, using url $urlCounter, number of segments to download to $streamSegNum, algorithm to use $algoName, videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth Mbps and gpac command to $gpacCommand"
fi

if [ $# -eq 1 ]
  then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=1
    # clip to use
    urlCounter=0
    # number of segments to stream
    streamSegNum=7;
    # algorithm to use
    algoName=default;
    # video output to use
    videoDriver="X11"
	# segment duration length in seconds
	playValue=2
    # bandwidth - pacing level
    pacingBandwidth=5
    # extra GPAC commands
    gpacCommand=""
    
    echo "Setting scenario folder to $scenFolder and using default values for the remainder - client number to $clientCounter, url $urlCounter, number of segments to download to $streamSegNum, algorithm to use $algoName, videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth Mbps and gpac command to $gpacCommand"
fi

if [ $# -eq 2 ]
then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=$2
    # clip to use
    urlCounter=0
    # number of segments to stream
    streamSegNum=7;
    # algorithm to use
    algoName=default;
    # video output to use
    videoDriver="X11"
	# segment duration length in seconds
	playValue=2
    # bandwidth - pacing level
    pacingBandwidth=5
    # extra GPAC commands
    gpacCommand=""

    echo "Setting scenario folder to $scenFolder client number to $clientCounter and using default values for the remainder - url to $urlCounter, number of segments to download to $streamSegNum, algorithm to use $algoName, videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth Mbps and gpac command to $gpacCommand"
fi

if [ $# -eq 3 ]
then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=$2
    # clip to use
    urlCounter=$3
    # number of segments to stream
    streamSegNum=7;
    # algorithm to use
    algoName=default;
    # video output to use
    videoDriver="X11"
	# segment duration length in seconds
	playValue=2
    # bandwidth - pacing level
    pacingBandwidth=5
    # extra GPAC commands
    gpacCommand=""

    echo "Setting scenario folder to $scenFolder client number to $clientCounter, using url $urlCounter and using default values for the remainder - number of segments to download to $streamSegNum, algorithm to use $algoName, videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth Mbps and gpac command to $gpacCommand"
fi

if [ $# -eq 4 ]
then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=$2
    # clip to use
    urlCounter=$3
    # number of segments to stream
    streamSegNum=$4
    # algorithm to use
    algoName=default;
    # video output to use
    videoDriver="X11"
	# segment duration length in seconds
	playValue=2
    # bandwidth - pacing level
    pacingBandwidth=5
    # extra GPAC commands
    gpacCommand=""

    echo "Setting scenario folder to $scenFolder client number to $clientCounter, using url $urlCounter, number of segments to download to $streamSegNum and using default values for the remainder -  algorithm to use $algoName, videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth Mbps and gpac command to $gpacCommand"
fi

if [ $# -eq 5 ]
then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=$2
    # clip to use
    urlCounter=$3
    # number of segments to stream
    streamSegNum=$4
    # algorithm to use
    algoName=$5
    # video output to use
    videoDriver="X11"
	# segment duration length in seconds
	playValue=2
    # bandwidth - pacing level
    pacingBandwidth=5
    # extra GPAC commands
    gpacCommand=""

    echo "Setting scenario folder to $scenFolder client number to $clientCounter, using url $urlCounter, number of segments to download to $streamSegNum, algorithm to use $algoName  and using default values for the remainder - videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth, and gpac command to $gpacCommand"
fi

if [ $# -eq 6 ]
then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=$2
    # clip to use
    urlCounter=$3
    # number of segments to stream
    streamSegNum=$4
    # algorithm to use
    algoName=$5
    # video output to use
    videoDriver=$6
	# segment duration length in seconds
	playValue=2
    # bandwidth - pacing level
    pacingBandwidth=5
    # extra GPAC commands
    gpacCommand=""

    echo "Setting scenario folder to $scenFolder client number to $clientCounter, using url $urlCounter, number of segments to download to $streamSegNum, algorithm to use $algoName, videoDriver to use to $videoDriver and using default values for the remainder - a segment duration of $playValue, a bandwidth of $pacingBandwidth, and gpac command to $gpacCommand"
fi

if [ $# -eq 7 ]
then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=$2
    # clip to use
    urlCounter=$3
    # number of segments to stream
    streamSegNum=$4
    # algorithm to use
    algoName=$5
    # video output to use
    videoDriver=$6
	# segment duration length in seconds
	playValue=$7
    # bandwidth - pacing level
    pacingBandwidth=5
    # extra GPAC commands
    gpacCommand=""

    echo "Setting scenario folder to $scenFolder client number to $clientCounter, using url $urlCounter, number of segments to download to $streamSegNum, algorithm to use $algoName, videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth, and gpac command to $gpacCommand"
fi

if [ $# -eq 8 ]
then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=$2
    # clip to use
    urlCounter=$3
    # number of segments to stream
    streamSegNum=$4
    # algorithm to use
    algoName=$5
    # video output to use
    videoDriver=$6
	# segment duration length in seconds
	playValue=$7
    # bandwidth - pacing level
    pacingBandwidth=$8
    # extra GPAC commands
    gpacCommand=""

    echo "Setting scenario folder to $scenFolder client number to $clientCounter, using url $urlCounter, number of segments to download to $streamSegNum, algorithm to use $algoName, videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth, and gpac command to $gpacCommand"
fi

if [ $# -eq 9 ]
then
    # scenario folder
    scenFolder=$1
    # number of clients
    clientCounter=$2
    # clip to use
    urlCounter=$3
    # number of segments to stream
    streamSegNum=$4
    # algorithm to use
    algoName=$5
    # video output to use
    videoDriver=$6
	# segment duration length in seconds
	playValue=$7
    # bandwidth - pacing level
    pacingBandwidth=$8
    # extra GPAC commands
    gpacCommand=$9

    echo "Setting scenario folder to $scenFolder client number to $clientCounter, using url $urlCounter, number of segments to download to $streamSegNum, algorithm to use $algoName, videoDriver to use to $videoDriver, a segment duration of $playValue, a bandwidth of $pacingBandwidth, and gpac command to $gpacCommand"
fi



# duration of the clip
clipDuration=16min

# list of urls - each url is an adaptive DASH stream




# x264 - complete list
urlsDASH=( 
        http://9.0.0.2/x264_2sec/Clip_1_16min/Clip_1_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_2_16min/Clip_2_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_3_16min/Clip_3_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_4_16min/Clip_4_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_5_16min/Clip_5_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_6_16min/Clip_6_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_7_16min/Clip_7_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_8_16min/Clip_8_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_9_16min/Clip_9_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_10_16min/Clip_10_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_11_16min/Clip_11_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_12_16min/Clip_12_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_13_16min/Clip_13_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_14_16min/Clip_14_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_15_16min/Clip_15_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_16_16min/Clip_16_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_17_16min/Clip_17_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_18_16min/Clip_18_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_19_16min/Clip_19_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_20_16min/Clip_20_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_21_10min/Clip_21_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_22_10min/Clip_22_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_2sec/Clip_23_16min/Clip_23_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_1_16min/Clip_1_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_2_16min/Clip_2_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_3_16min/Clip_3_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_4_16min/Clip_4_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_5_16min/Clip_5_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_6_16min/Clip_6_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_7_16min/Clip_7_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_8_16min/Clip_8_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_9_16min/Clip_9_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_10_16min/Clip_10_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_11_16min/Clip_11_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_12_16min/Clip_12_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_13_16min/Clip_13_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_14_16min/Clip_14_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_15_16min/Clip_15_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_16_16min/Clip_16_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_17_16min/Clip_17_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_18_16min/Clip_18_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_19_16min/Clip_19_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_20_16min/Clip_20_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_21_10min/Clip_21_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_22_10min/Clip_22_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_4sec/Clip_23_16min/Clip_23_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_1_16min/Clip_1_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_2_16min/Clip_2_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_3_16min/Clip_3_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_4_16min/Clip_4_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_5_16min/Clip_5_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_6_16min/Clip_6_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_7_16min/Clip_7_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_8_16min/Clip_8_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_9_16min/Clip_9_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_10_16min/Clip_10_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_11_16min/Clip_11_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_12_16min/Clip_12_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_13_16min/Clip_13_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_14_16min/Clip_14_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_15_16min/Clip_15_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_16_16min/Clip_16_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_17_16min/Clip_17_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_18_16min/Clip_18_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_19_16min/Clip_19_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_20_16min/Clip_20_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_21_10min/Clip_21_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_22_10min/Clip_22_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_6sec/Clip_23_16min/Clip_23_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_1_16min/Clip_1_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_2_16min/Clip_2_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_3_16min/Clip_3_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_4_16min/Clip_4_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_5_16min/Clip_5_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_6_16min/Clip_6_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_7_16min/Clip_7_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_8_16min/Clip_8_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_9_16min/Clip_9_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_10_16min/Clip_10_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_11_16min/Clip_11_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_12_16min/Clip_12_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_13_16min/Clip_13_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_14_16min/Clip_14_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_15_16min/Clip_15_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_16_16min/Clip_16_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_17_16min/Clip_17_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_18_16min/Clip_18_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_19_16min/Clip_19_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_20_16min/Clip_20_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_21_10min/Clip_21_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_22_10min/Clip_22_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_8sec/Clip_23_16min/Clip_23_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_1_16min/Clip_1_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_2_16min/Clip_2_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_3_16min/Clip_3_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_4_16min/Clip_4_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_5_16min/Clip_5_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_6_16min/Clip_6_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_7_16min/Clip_7_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_8_16min/Clip_8_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_9_16min/Clip_9_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_10_16min/Clip_10_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_11_16min/Clip_11_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_12_16min/Clip_12_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_13_16min/Clip_13_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_14_16min/Clip_14_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_15_16min/Clip_15_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_16_16min/Clip_16_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_17_16min/Clip_17_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_18_16min/Clip_18_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_19_16min/Clip_19_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_20_16min/Clip_20_enc_16min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_21_10min/Clip_21_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_22_10min/Clip_22_enc_10min_x264_dash.mpd
        http://9.0.0.2/x264_10sec/Clip_23_16min/Clip_23_enc_16min_x264_dash.mpd
    )


# folder structure

folderDASH=( c1_x264 c2_x264 c3_x264 c4_x264 c5_x264 c6_x264 c7_x264 c8_x264 c9_x264 c10_x264 c11_x264 c12_x264 c13_x264 c14_x264 c15_x264 c16_x264 c17_x264 c18_x264 c19_x264 c20_x264 c21_x264 c22_x264 c23_x264 c1_x264 c2_x264 c3_x264 c4_x264 c5_x264 c6_x264 c7_x264 c8_x264 c9_x264 c10_x264 c11_x264 c12_x264 c13_x264 c14_x264 c15_x264 c16_x264 c17_x264 c18_x264 c19_x264 c20_x264 c21_x264 c22_x264 c23_x264 c1_x264 c2_x264 c3_x264 c4_x264 c5_x264 c6_x264 c7_x264 c8_x264 c9_x264 c10_x264 c11_x264 c12_x264 c13_x264 c14_x264 c15_x264 c16_x264 c17_x264 c18_x264 c19_x264 c20_x264 c21_x264 c22_x264 c23_x264 c1_x264 c2_x264 c3_x264 c4_x264 c5_x264 c6_x264 c7_x264 c8_x264 c9_x264 c10_x264 c11_x264 c12_x264 c13_x264 c14_x264 c15_x264 c16_x264 c17_x264 c18_x264 c19_x264 c20_x264 c21_x264 c22_x264 c23_x264 c1_x264 c2_x264 c3_x264 c4_x264 c5_x264 c6_x264 c7_x264 c8_x264 c9_x264 c10_x264 c11_x264 c12_x264 c13_x264 c14_x264 c15_x264 c16_x264 c17_x264 c18_x264 c19_x264 c20_x264 c21_x264 c22_x264 c23_x264 )
# (sstb ed bbb)

# store the start time
dt=`date '+%d_%m_%Y_%H_%M_%S'`

# create a local folder for this test
outputFolder=${scenFolder}/${dt}_clientID$((clientCounter))
outputFolderName=${dt}_clientID$((clientCounter))
mkdir -p $outputFolder

# copy the current default GPAC config file to our local folder
cp ~/.gpac/GPAC.cfg $outputFolder/ourGpacrc

# set the algorithm name and the number of segments to stream
awk -v algor=$algoName -v numSeg=$streamSegNum 'BEGIN{algorName=algor; streamSegnum=numSeg;} {if($0 ~ "algorithm="){ printf("algorithm=%s\n", algorName);}else if($0 ~ "NumOfSegToDownload="){ printf("NumOfSegToDownload=%s\n", streamSegnum);}else{print($0)}}' ./adaptiveGPACrc > ./adaptiveGPACrc_temp

# get the algorithm name
# algorithm=`awk 'BEGIN{algo="default"} {if($0 ~ "algorithm="){ split($0, array,"="); algo=array[2]; }} END{print(algo)}' ./adaptiveGPACrc`

# set the number of segments to stream
# awk -v numSeg=$streamSegNum 'BEGIN{streamSegnum=numSeg;} {if($0 ~ "NumOfSegToDownload="){ printf("NumOfSegToDownload=%s\n", streamSegnum);}else{print($0)}}' ./adaptiveGPACrc > ./adaptiveGPACrc_temp

# update our adaptiveGPACrc file
mv ./adaptiveGPACrc_temp ./adaptiveGPACrc

# if the algorithm choice is "highest", then we need to change the initial representation setting to maxBandwidth
if [ "$algoName" == "highest" ]
then
    awk '{if($0 == "StartRepresentation=minBandwidth"){ printf("StartRepresentation=maxBandwidth\n"); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
    mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc
fi

# change the player output from X11 to RAW
awk -v vid=$videoDriver 'BEGIN{videodriver=vid; streamSegnum=numSeg;} {if($0 ~ "DriverName=X11"){ printf("DriverName=%s Video Output\n", videodriver); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc

# we need to reset the buffer size for festive and bba2
if [ "$algoName" == "festive" ]
then
    awk '{if($0 ~ "BufferLength="){ printf("BufferLength=30000\n"); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
    mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc
fi

if [ "$algoName" == "default" ]
then
    awk '{if($0 ~ "BufferLength="){ printf("BufferLength=15000\n"); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
    mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc
fi

if [ "$algoName" == "conv" ]
then
    awk '{if($0 ~ "BufferLength="){ printf("BufferLength=30000\n"); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
    mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc
fi

if [ "$algoName" == "bba2"  ]
then
    awk '{if($0 ~ "BufferLength="){ printf("BufferLength=240000\n"); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
    mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc
fi

if [ "$algoName" == "elastic" ]
then
    awk '{if($0 ~ "BufferLength="){ printf("BufferLength=30000\n"); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
    mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc
fi


if [ "$algoName" == "arbiter" ]
then
    awk '{if($0 ~ "BufferLength="){ printf("BufferLength=60000\n"); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
    mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc
fi

# let's define some additional configuration settings we want - leave 1 space lines at the top of the file and 1 space line at the end
# we store our config information under the tag [ADAPTIVE]
cat ./adaptiveGPACrc >> $outputFolder/ourGpacrc

# reset the playoutlength for default
awk -v vid=$(( $playValue * 2000 )) '{if($0 ~ "PlayoutLength="){ printf("PlayoutLength=%s\n", vid); }else{print($0)}}' $outputFolder/ourGpacrc > $outputFolder/ourGpacrc_temp
    mv $outputFolder/ourGpacrc_temp $outputFolder/ourGpacrc


outputFile=${folderDASH[$urlCounter]}_${clipDuration}_clientID$((clientCounter))_${pacingBandwidth}Mbps.txt

echo "MP4Client -lf $outputFolder/$outputFile -cfg $outputFolder/ourGpacrc $gpacCommand -logs dash:network@debug ${urlsDASH[$urlCounter]}"

# run our GPAC client script
MP4Client -exit -cfg $outputFolder/ourGpacrc -lf $outputFolder/$outputFile $gpacCommand -logs dash:network@debug ${urlsDASH[$urlCounter]}

# create the columned trace file
./MP4Client_DASH_Stream_AdapatationScript.sh $outputFolderName $outputFile $algoName $streamSegNum ${folderDASH[$urlCounter]} $((clientCounter)) ${scenFolder}

#dash:network
# MP4Client -lf temp.txt -logs dash:network@debug http://localhost/x265_multi_rep/Clip_4_16min/Clip_4_enc_16min_x265_dash.mpd
