#!/bin/bash

# =============  USER CONFIG SOURCE FILES ==============
source config_files/user_input.conf

server=$1;
clientNum=$2;
algo=$3;
urlNum=$4;
trace_output_folder=$5;
model=$6;
timeOut=$7;
numSegments=$8;
ClientSleepTime=$9;
segDuration=${10};
output_folder=${11};

# =============  CONNECT TO REMOTE CLIENT AND RUN GPAC ==============

my_output_folder=${output_folder}/client${DEVICE[${clientNum}]}

echo $my_output_folder

# mkdir -p $output_folder

# single quotes just sends the text
sudo -u user1 ssh ${server} -o ConnectTimeout=${timeOut} "export DISPLAY=:0; cd ~/Code/GPAC_test_code; sleep ${ClientSleepTime}; ./DASH_MP4Client_script.sh ${folder} ${clientNum} ${urlNum} ${numSegments} ${algo} ${videoDriver} ${segDuration}; /bin/bash" 2> $my_output_folder/$output_GPAC_file
