#!/bin/bash

# make sure you make this file executable
# chmod +x ssh_create.sh

# using this website: http://www.tecmint.com/ssh-passwordless-login-using-ssh-keygen-in-5-easy-steps/

# run this first to create a pair of public keys
# ssh-keygen -t rsa

# next set up the client details
user=user1
# this needs to be client IP address
ip=12.0.0.52

echo ${user}@${ip}

# create a folder on the remote machine
ssh ${user}@${ip} mkdir -p .ssh

echo ""

# upload public key to the remote machine
cat ~/.ssh/id_rsa.pub | ssh ${user}@${ip} 'cat >> .ssh/authorized_keys'

# change permissions on the remote keys
ssh ${user}@${ip} "chmod 700 .ssh; chmod 640 .ssh/authorized_keys"

# check to see if we can indeed login without password
ssh ${user}@${ip}


# example
# ssh user1@12.0.0.22 mkdir -p .ssh
# cat ~/.ssh/id_rsa.pub | ssh user1@12.0.0.22 'cat >> .ssh/authorized_keys'
# ssh user1@12.0.0.22 "chmod 700 .ssh; chmod 640 .ssh/authorized_keys"
# ssh user1@12.0.0.22


