#!/bin/bash

# this file needs to be called from "SAP_master" and not from "file-copying"
# i.e. ./file_copying/copy_files_to_clients.sh

# =============  USER CONFIG SOURCE FILES ==============
source config_files/user_input.conf

# =============  RUN TO SETUP NS3-LTE ==============

echo "Running Script for 120 seconds."

# let's begin by running ns3-lte - we are going to run the simulation
dsh -M -g ns3 "cd ~/Code/ns-3-allinone/ns-3-dev; ./waf --run \"scratch/lena-simple-epc-tap-nas-test11 --numberOfNodes=$lte_clients --simTime=120 --distance1=0.0 --distance2=0.0 --distance3=0.0 --distance4=0.0 --distance5=0.0 --distance6=0.0\"" > trace_files/fileCopyToClient.txt &


# =============  RUN TO COPY FILES TO THE CLIENTS ==============

# give the script enough time to build before running the clients
sleep $build_sleep

echo "Copy Files to Clients"
for cIndex in `seq 1 $lte_clients`; 
do 
   # print the server name
   printf "client" $server "\n";

   # copy our main script
   scp ./GPAC_test_code/DASH_MP4Client_script.sh user1@"12.0.0."${DEVICE[${cIndex}]}:~/Code/GPAC_test_code/DASH_MP4Client_script.sh &

   # copy our adaptive file
   scp ./GPAC_test_code/adaptiveGPACrc user1@"12.0.0."${DEVICE[${cIndex}]}:~/Code/GPAC_test_code/adaptiveGPACrc &

   # copy our trace columnised script
   scp ./GPAC_test_code/MP4Client_DASH_Stream_AdapatationScript.sh user1@"12.0.0."${DEVICE[${cIndex}]}:~/Code/GPAC_test_code/MP4Client_DASH_Stream_AdapatationScript.sh &

   # copy our script folder
   scp -r ./GPAC_test_code/Script_Files user1@"12.0.0."${DEVICE[${cIndex}]}:~/Code/GPAC_test_code &

done
