#!/bin/bash

# in this script we call the script 'run_GPAC.sh' in a terminal window per client

# =============  USER CONFIG SOURCE FILES ==============
source config_files/user_input.conf

algo=$1;
urlNum=$2;
trace_output_folder=$3;
model=$4;
timeOut=$5;
numSegCounter=$6;
numSegments=$7;
segDuration=$8;
output_folder=$9;

# =============  RUN EACH CLIENT IN A SEPERATE TERMINAL ==============

echo "Run MP4Client"
# loop over clients
for cIndex in `seq 1 $lte_clients`; 
do 
   printf "Client $cIndex \n" ;
  
   # the url index needs to consider the url selected and the seg duration index
   client_index_less_one=$((cIndex-1))
   
   # echo $client_index_less_one
   
   # sleep time for this client
   # ClientSleepTime=${clientSleepDurations[$client_index_less_one]}
   clientWaitTime="clientSleepDurations_${urlNum}[$client_index_less_one]"
   ClientSleepTime=$(echo ${!clientWaitTime})
   echo "Sleep" $ClientSleepTime "seconds for client IP 12.0.0."${DEVICE[cIndex]}

   # update ClientSleepTime to include the initial LTE network run time of $build_sleep
   #ClientSleepTime=$(( $ClientSleepTime + $(( 2* $build_sleep )) ))
   ClientSleepTime=$(echo "scale=3; $ClientSleepTime+( 2 * $build_sleep )" | bc)
   
   echo "Sleep total" $ClientSleepTime " seconds for client IP 12.0.0."${DEVICE[cIndex]}
   
   # url index to use for this user - we need the '!' to provide bash indirect expansion
   url_index="clip_array_run_${urlNum}[$client_index_less_one]"
   
   # echo $url_index

   # we need the '!' to provide bash indirect expansion
   url_to_use=$(echo ${!url_index})
   
   # echo $url_to_use
   
   # add in the additional url index for each of the other segment durations
   url_to_use=$(( ${url_to_use} + $(( $numSegCounter * $numClips)) ))
   
   # echo $url_to_use
   
   echo "index to use for client IP 12.0.0."${DEVICE[cIndex]} "is url index" ${url_to_use}

   # run the ssh in a new terminal window
   gnome-terminal -e "./GPAC/run_GPAC_per_client.sh client${cIndex} ${cIndex} ${algo} ${url_to_use} ${trace_output_folder} ${model} ${timeOut} ${numSegments} ${ClientSleepTime} ${segDuration} ${output_folder}" &

done
