package edu.ucc.workload;

import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.core.events.simulationevents.RequestEvent;
import edu.ucc.entities.File;

import java.io.Serializable;
import java.util.*;

public class Workload implements Serializable {
    private final Map<Integer, List<RequestEvent>> requestEventsPerApp;
    private List<HandoverEvent> mobilityEvents;
    /**
     * This helps to populate the mobility information for the system. These events should correspond to those in the
     * MobilityGenerator
     */
    private List<HandoverEvent> initialMobilityEvents;
    private List<File> filesUniverse;

    public Workload() {
        this.requestEventsPerApp = new HashMap<>();
        this.mobilityEvents = new ArrayList<>();
        this.filesUniverse = new ArrayList<>();
    }

    public Set<Integer> getAppsIds() {
        return requestEventsPerApp.keySet();
    }

    public void setRequestEvents(int appId, List<RequestEvent> requestEvents) {
        this.requestEventsPerApp.put(appId, requestEvents);
    }

    public void setMobilityEvents(List<HandoverEvent> mobilityEvents) {
        this.mobilityEvents = mobilityEvents;
    }

    public void setInitialMobilityEvents(List<HandoverEvent> initialMobilityEvents) {
        this.initialMobilityEvents = initialMobilityEvents;
    }

    public List<HandoverEvent> getInitialMobilityEvents() {
        return initialMobilityEvents;
    }

    //    public List<RequestEvent> getRequestEvents(int appId) {
    //        final List<RequestEvent> realWorldEvents = requestEventsPerApp.get(appId);
    //        if (realWorldEvents == null) return new ArrayList<>();
    //        return realWorldEvents;
    //    }

    public List<RequestEvent> getRequestEvents() {
        List<RequestEvent> allRequestEvents = new ArrayList<>();
        for (Map.Entry<Integer, List<RequestEvent>> entry : requestEventsPerApp.entrySet()) {
            allRequestEvents.addAll(entry.getValue());
        }
        return allRequestEvents;
    }

    public List<HandoverEvent> getMobilityEvents() {
        return mobilityEvents;
    }

    public void setFilesUniverse(List<File> filesUniverse) {
        this.filesUniverse = filesUniverse;
    }

    public List<File> getFilesUniverse() {
        return filesUniverse;
    }
}

