package edu.ucc.utils;

import edu.ucc.core.Simulation;

import java.io.*;

public class SimulationClassFileHandling {
    public static void saveSimulationToFile(Simulation simulation, String filePath) {
        try (
                FileOutputStream fout = new FileOutputStream(filePath, true);
                ObjectOutputStream oos = new ObjectOutputStream(fout)
        ) {
            oos.writeObject(simulation);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Simulation readSimulationFromFile(String filePath) {
        try (FileInputStream stream = new FileInputStream(filePath);
             ObjectInputStream objectInputStream = new ObjectInputStream(stream)
        ) {
            return (Simulation) objectInputStream.readObject();
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Can't continue, simulation loading failed");
        }
    }


}
