package edu.ucc.utils;

import edu.ucc.core.Simulation;
import edu.ucc.core.events.simulationevents.*;
import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.Host;

public class Logging {
    // public static final String BLACK_BACKGROUND = "\u001b[40m";
    // public static final String RED_BACKGROUND = "\u001b[41m";
    // public static final String GREEN_BACKGROUND = "\u001b[42m";
    // public static final String YELLOW_BACKGROUND = "\u001b[43m";
    // public static final String BLUE_BACKGROUND = "\u001b[44m";
    // public static final String MAGENTA_BACKGROUND = "\u001b[45m";
    // public static final String CYAN_BACKGROUND = "\u001b[46m";
    // public static final String WHITE_BACKGROUND = "\u001b[47m";
    public static final String BRIGHT_YELLOW_BACKGROUND = "\u001b[43;1m";

    public static final String ANSI_RESET = "\u001B[0m";
    // public static final String ANSI_BLACK = "\u001B[30m";
    public static final String ANSI_RED = "\u001B[31m";
    public static final String ANSI_BRIGHT_RED = "\u001b[31;1m";
    public static final String ANSI_GREEN = "\u001B[32m";
    public static final String ANSI_YELLOW = "\u001B[33m";
    public static final String ANSI_BRIGHT_YELLOW = "\u001B[33;1m";
    public static final String ANSI_BLUE = "\u001B[34m";
    public static final String ANSI_PURPLE = "\u001B[35m";
    public static final String ANSI_CYAN = "\u001B[36m";
    // public static final String ANSI_WHITE = "\u001B[37m";

    public static final String ANSI_BRIGHT_MAGENTA = "\u001b[35;1m";

    public static final short VERBOSE = 0b00000001;
    public static final short INFO = VERBOSE << 1;
    public static final short DEBUG = VERBOSE << 2;
    public static final short WARNING = VERBOSE << 3;
    public static final short ERROR = VERBOSE << 4;
    public static final short HANDOVER = VERBOSE << 5;
    public static final short CHUNK = VERBOSE << 6;
    public static final short ACK = VERBOSE << 7;
    public static final short PULL_DATA_REQUEST = VERBOSE << 8;
    public static final short PULL_FILE_REQUEST = VERBOSE << 9;
    public static final short PUSH_DATA_REQUEST = VERBOSE << 10;
    public static final short PUSH_FILE_REQUEST = VERBOSE << 11;
    public static final short PREFETCH_FILE_REQUEST = VERBOSE << 12;
    public static final short CONTENT_RECEIVED = VERBOSE << 13;

    public static int PRINT_CONFIGURATION = PULL_DATA_REQUEST | PULL_FILE_REQUEST
            | PUSH_FILE_REQUEST | PUSH_DATA_REQUEST | INFO | CHUNK;

    public static void configureLogging(int mask) {
        PRINT_CONFIGURATION = mask;
    }

    public static void printWarning(String warningString) {
        if ((PRINT_CONFIGURATION & WARNING) == WARNING) {
            // System.out.println(ANSI_BRIGHT_MAGENTA + BRIGHT_YELLOW_BACKGROUND + warningString + ANSI_RESET);
            System.out.println(ANSI_BRIGHT_YELLOW + warningString + ANSI_RESET);
        }
    }

    public static void printInfo(String infoString) {
        if ((PRINT_CONFIGURATION & INFO) == INFO) {
            System.out.println(ANSI_GREEN + infoString + ANSI_RESET);
        }
    }

    public static void printDebug(String debugString) {
        if ((PRINT_CONFIGURATION & DEBUG) == DEBUG)
            System.out.println(ANSI_CYAN + debugString + ANSI_RESET);
    }

    public static void printVerbose(String verboseString) {
        if ((PRINT_CONFIGURATION & VERBOSE) == 1) {
            System.out.println(verboseString);
        }
    }

    public static void printError(String errorString) {
        if ((PRINT_CONFIGURATION & ERROR) == ERROR) {
            System.out.println(ANSI_BRIGHT_RED + errorString + ANSI_RESET);
        }
    }

    public static void printHandoverMessage(String handoverString) {
        if ((PRINT_CONFIGURATION & HANDOVER) == HANDOVER) {
            System.out.println(ANSI_PURPLE + handoverString + ANSI_RESET);
        }
    }

    public static void logRequest(RequestEvent requestEvent) {
        boolean print = false;
        if (requestEvent instanceof PullDataRequestEvent && (PRINT_CONFIGURATION & PULL_DATA_REQUEST) == PULL_DATA_REQUEST)
            print = true;
        if (requestEvent instanceof PullFileRequestEvent && (PRINT_CONFIGURATION & PULL_FILE_REQUEST) == PULL_FILE_REQUEST)
            print = true;
        if (requestEvent instanceof PushDataRequestEvent && (PRINT_CONFIGURATION & PUSH_DATA_REQUEST) == PUSH_DATA_REQUEST)
            print = true;
        if (requestEvent instanceof PushFileRequestEvent && (PRINT_CONFIGURATION & PUSH_FILE_REQUEST) == PUSH_FILE_REQUEST)
            print = true;
        if (requestEvent instanceof PrefetchRequestEvent && (PRINT_CONFIGURATION & PREFETCH_FILE_REQUEST) == PREFETCH_FILE_REQUEST)
            print = true;

        if (print) {
            System.out.println(ANSI_BLUE + requestEvent.toString() + ANSI_RESET);
        }
    }

    public static void logContentReceived(ContentReceivedEvent receivedEvent) {
        if ((PRINT_CONFIGURATION & CONTENT_RECEIVED) == CONTENT_RECEIVED) {
            System.out.println(ANSI_PURPLE + receivedEvent.toString() + ANSI_RESET);
        }
    }

    public static void logChunk(ChunkReceivedEvent chunkReceivedEvent) {
        if ((PRINT_CONFIGURATION & CHUNK) == CHUNK) {
            System.out.println(ANSI_YELLOW + chunkReceivedEvent.toString() + ANSI_RESET);
        }
    }

    public static void logAck(AckReceivedEvent ackReceivedEvent) {
        if ((PRINT_CONFIGURATION & ACK) == ACK) {
            System.out.println(ANSI_CYAN + ackReceivedEvent.toString() + ANSI_RESET);
        }
    }

    public static void printDroppedChunkWarning(Host host, ChunkReceivedEvent chunkReceivedEvent, Host destinationHost) {
        ContentChunk chunk = chunkReceivedEvent.getChunk();
        printWarning(String.format("[ChunkEvent] At %s %s, Dropping chunk %s for file %s  for %s %s bc lack of link, " +
                        "maybe handover? @ %s", host.getTypeAsString(), host.getId(),
                chunk.getChunkNumber(), chunk.getRequestEvent().getReferredContent().getURI(), destinationHost.getTypeAsString(),
                destinationHost.getId(), Simulation.getInstance().getCurrentTime()));
    }

    public static void doColors() {
        //        http://www.lihaoyi.com/post/BuildyourownCommandLinewithANSIescapecodes.html
        for (int i = 0; i < 16; i++) {
            for (int j = 0; j < 16; j++) {
                int code = i * 16 + j;
                String codeAsStr = "\u001b[38;5;" + code + "m ";
                System.out.print(codeAsStr + "" + code + "\t" + ANSI_RESET);
            }
            System.out.println();
        }
        System.out.println("\u001b[40m A \u001b[41m B \u001b[42m C \u001b[43m D \u001b[0m");
        System.out.println("\u001b[1m BOLD \u001b[0m\u001b[4m Underline \u001b[0m\u001b[7m Reversed \u001b[0m");
    }
}
