package edu.ucc.testbedinterface;

import edu.ucc.core.events.simulationevents.*;
import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.EdgeServer;
import edu.ucc.network.devices.Host;

import java.util.List;

public interface ObservableTestbedEventListener {
    void onContentReceptionCompleted(Host host, ContentReceivedEvent contentReceivedEvent);

    void onPullRequestServedLocally(EdgeServer edgeServer, PullRequestEvent pullRequestEvent);

    /**
     * To detect workload.mobility patterns (if any) of User Equipments.
     * To update the File Systems of hosts so that Data from UEs can be located (Files are "static" they don't change,
     * as they are the same wherever they are).
     *
     * @param host          The host that is handling the event
     * @param handoverEvent The event reference.
     */
    void onUserEquipmentHandover(Host host, HandoverEvent handoverEvent);

    void onPrefetchRequestReceived(Host host, PrefetchRequestEvent prefetchRequestEvent);

    List<SimulationEvent> createInitialControlEvents();

    /**
     * Finds out whether the specified app is deployed at specified host.
     * @param host The host to look the app in.
     * @param appId The id of the app to find.
     * @return true if the app is running at the host (i.e., server)
     */
    boolean isAppDeployedHere(Host host, int appId);

    /**
     * Finds out the destination host for a chunk that is received at an edge server where the app is not running.
     *
     * @param chunk      The received chunk.
     * @param edgeServer The edge server where the chunk is received and where the app is not running.
     * @param appId      The id of the app.
     * @return The host where the chunk must be relayed. It only can be the cloud or a sibling edge server.
     */
    Host findDestinationForChunkAtServerWithoutApp(ContentChunk chunk, EdgeServer edgeServer, int appId);

    /**
     * This method helps to register the initial location of mobile devices within the solution
     * @param initialMobilityEvents The list of initial mobility events.
     */
    void registerInitialMobilityEvent(List<HandoverEvent> initialMobilityEvents);
}
