package edu.ucc.statisticscollection;

public class TrafficRecord {
    private final int pullFileRequestsToCloud;
    private final long chunksSentByCloudForPullRequests;
    private final long chunksSentByCloudForPrefetchRequests;
    private final int pullFileRequestsInWorkload;
    private final int prefetchFileRequestsInWorkload;
    private final long theoreticalMaxChunksInPullFileRequests;
    private final long theoreticalMaxChunksInPrefetchFileRequests;
    private final int pullFileRequestsToEdgeServers;
    private final long chunksSentByEdgeServers;
    private final double pcChunksByESs;
    private final double pcRequestsByESs;
    private final double pcOfTheoreticalMaxTraffic;


    public TrafficRecord(int pullFileRequestsToCloud, long chunksSentByCloudForPullRequest,
                         long chunksSentByCloudForPrefetchRequests, int pullFileRequestsInWorkload,
                         int prefetchFileRequestsInWorkload,
                         long theoreticalMaxChunksInPullFileRequests,
                         long theoreticalMaxChunksInPrefetchFileRequests,
                         int pullFileRequestsToEdgeServers,
                         long chunksSentByEdgeServers, double pcChunksByESs, double pcRequestsByESs,
                         double pcOfTheoreticalMaxTraffic) {
        this.pullFileRequestsToCloud = pullFileRequestsToCloud;
        this.chunksSentByCloudForPullRequests = chunksSentByCloudForPullRequest;
        this.chunksSentByCloudForPrefetchRequests = chunksSentByCloudForPrefetchRequests;
        this.pullFileRequestsInWorkload = pullFileRequestsInWorkload;
        this.prefetchFileRequestsInWorkload = prefetchFileRequestsInWorkload;
        this.theoreticalMaxChunksInPullFileRequests = theoreticalMaxChunksInPullFileRequests;
        this.theoreticalMaxChunksInPrefetchFileRequests = theoreticalMaxChunksInPrefetchFileRequests;
        this.pullFileRequestsToEdgeServers = pullFileRequestsToEdgeServers;
        this.chunksSentByEdgeServers = chunksSentByEdgeServers;
        this.pcChunksByESs = pcChunksByESs;
        this.pcRequestsByESs = pcRequestsByESs;
        this.pcOfTheoreticalMaxTraffic = pcOfTheoreticalMaxTraffic;
    }

    public int getPullFileRequestsToCloud() {
        return pullFileRequestsToCloud;
    }

    public long getChunksSentByCloudForPullRequests() {
        return chunksSentByCloudForPullRequests;
    }

    public int getPullFileRequestsInWorkload() {
        return pullFileRequestsInWorkload;
    }

    public long getTheoreticalMaxChunksInPullFileRequests() {
        return theoreticalMaxChunksInPullFileRequests;
    }

    public int getPullFileRequestsToEdgeServers() {
        return pullFileRequestsToEdgeServers;
    }

    public long getChunksSentByEdgeServers() {
        return chunksSentByEdgeServers;
    }

    public double getPcChunksByESs() {
        return pcChunksByESs;
    }

    public double getPcRequestsByESs() {
        return pcRequestsByESs;
    }

    public double getPcOfTheoreticalMaxTraffic() {
        return pcOfTheoreticalMaxTraffic;
    }

    public long getChunksSentByCloudForPrefetchRequests() {
        return chunksSentByCloudForPrefetchRequests;
    }

    public int getPrefetchFileRequestsInWorkload() {
        return prefetchFileRequestsInWorkload;
    }
}
