//package edu.ucc.statisticscollection;
//
//import edu.ucc.core.Simulation;
//import edu.ucc.network.devices.*;
//import Workload;
//import edu.ucc.utils.HierarchyUtils;
//
//import java.io.*;
//import java.util.ArrayList;
//import java.util.Comparator;
//import java.util.List;
//
//import static WorkloadGenerationConstants.RANDOM_SEED;
//
//public class ResultsWriter {
//    private final String outputFolder;
//    private Simulation simulation;
//    private NetworkArchitecture networkArchitecture;
//    private Workload workload;
//
//    public ResultsWriter(Simulation simulation, String outputFolder) {
//        this.simulation = simulation;
//        this.networkArchitecture = simulation.getNetworkArchitecture();
//        this.workload = simulation.getWorkload();
//        this.outputFolder = outputFolder;
//    }
//
//    public void exportResults() throws IOException {
//        mkdir();
//        exportScenarioParameters();
//        exportDevices();
//        exportRequests();
//        exportFiles();
//    }
//
//    private void exportFiles() throws IOException {
//        String headerRow = "id,url,size";
//        String filesFileName = "files.csv";
//        final FileWriter fileWriter = new FileWriter(outputFolder + "\\" + filesFileName, false);
//        PrintWriter pw = new PrintWriter(new BufferedWriter(fileWriter));
//        pw.println(headerRow);
//        final List<edu.ucc.entities.File> files = simulation.getWorkload().getFilesUniverse();
//        for (edu.ucc.entities.File file : files) {
//            pw.println(String.format("%s,%s,%s", file.getId(), file.getUri(), file.getSize()));
//        }
//        pw.close();
//    }
//
//    private void exportRequests() throws IOException {
//        exportRequestsAtUserEquipments();
//        exportRequestsAtBaseStations();
//        exportRequestsAtEdgeServers();
//        exportRequestsAtCloud();
//    }
//
//    private void exportRequestsAtCloud() throws IOException {
////        final List<UserEquipment> userEquipments = networkArchitecture.getUserEquipments();
//        String requestsFileName = "requestsAtCloud.csv";
//        Host cloud = networkArchitecture.getCloudRoot();
//        List<Host> clouds = new ArrayList<>();
//        clouds.add(cloud);
//        exportRequestsAtHosts(clouds, requestsFileName);
//    }
//
//
//    private void exportRequestsAtEdgeServers() throws IOException {
//        final List<EdgeServer> edgeServers = networkArchitecture.getEdgeServers();
//        String requestsFileName = "requestsAtEdgeServers.csv";
//        exportRequestsAtHosts(edgeServers, requestsFileName);
//    }
//
//    private void exportRequestsAtBaseStations() throws IOException {
//        final List<BaseStation> baseStations = networkArchitecture.getBaseStations();
//        String requestsFileName = "requestsAtBaseStations.csv";
//        exportRequestsAtHosts(baseStations, requestsFileName);
//    }
//
//    private void exportRequestsAtUserEquipments() throws IOException {
//        final List<UserEquipment> userEquipments = networkArchitecture.getUserEquipments();
//        String requestsFileName = "requestsAtUserEquipments.csv";
//        exportRequestsAtHosts(userEquipments, requestsFileName);
//    }
//
//    private void exportRequestsAtHosts(List<? extends Host> hosts, String requestsFileName) throws IOException {
//        String headerRow = "request_id,host_id,file_id,completed,requested_at,first_chunk_at,completed_at,transmitted_chunks";
//        final FileWriter fileWriter = new FileWriter(outputFolder + "\\" + requestsFileName, false);
//        PrintWriter pw = new PrintWriter(new BufferedWriter(fileWriter));
//        pw.println(headerRow);
//        List<PullRequest> groupedRequests = new ArrayList<>();
//        for (Host host : hosts) {
//            final List<PullRequest> contentRequests = host.getContentRequests();
//            if (!contentRequests.isEmpty()) {
//                groupedRequests.addAll(contentRequests);
//            }
//        }
//
//        // sort them by request id
//        groupedRequests.sort(Comparator.comparingInt(PullRequest::getRequestId));
//
//        // print info
//        for (PullRequest contentRequest : groupedRequests) {
//            final int requestId = contentRequest.getRequestId();
//            final int hostId = contentRequest.getCurrentHost().getId();
//            final int fileId = contentRequest.getReferredContent().getId();
//            final boolean completed = contentRequest.isCompleted();
//            final double requestAt = contentRequest.getRequestTimestamp();
//            final double firstChunkAt = contentRequest.getFirstChunkReceivedAt();
//            final double completedAt = contentRequest.getCompletedAt();
//            final int transmittedChunks = contentRequest.getTransmittedChunks();
//            String line = String.format("%d,%d,%d,%s,%s,%s,%s,%d", requestId, hostId, fileId, completed, requestAt,
//                    firstChunkAt, completedAt, transmittedChunks);
//            pw.println(line);
//        }
//        pw.close();
//    }
//
//    private void exportScenarioParameters() throws IOException {
//        String scenarioFileName = "scenario.txt";
//        final FileWriter fileWriter = new FileWriter(outputFolder + "\\" + scenarioFileName, false);
//        PrintWriter pw = new PrintWriter(new BufferedWriter(fileWriter));
//        pw.println(String.format("seed=%s", RANDOM_SEED));
//        pw.println(String.format("num_equipments=%s", networkArchitecture.getArchitectureParameters().getNumUserEquipments()));
//        pw.println(String.format("num_edge_servers=%s", networkArchitecture.getArchitectureParameters().getNumEdgeServers()));
//        pw.println(String.format("num_base_stations=%s", networkArchitecture.getBaseStations().size()));
//        pw.println(String.format("map_width=%s", networkArchitecture.getArchitectureParameters().getMapWidth()));
//        pw.println(String.format("map_height=%s", networkArchitecture.getArchitectureParameters().getMapHeight()));
//        pw.println(String.format("bs_range=%s", networkArchitecture.getArchitectureParameters().getBsRange()));
//        pw.println(String.format("mtu=%s", networkArchitecture.getArchitectureParameters().getMtu()));
//        pw.close();
//    }
//
//    private void mkdir() {
//        File f = new File(outputFolder);
//        if (f.exists()) {
//            return;
//        }
//        final boolean created = f.mkdirs();
//        if (!created) {
//            throw new RuntimeException("Couldn't create the directory to write results");
//        }
//    }
//
//    private void exportDevices() throws IOException {
//        String devicesFileName = "devices.csv";
//        String headerRow = "device_type,device_id,parent_id,latitude,longitude,bw_ul_children,bw_dl_children,bw_siblings";
//        final FileWriter fileWriter = new FileWriter(outputFolder + "\\" + devicesFileName, false);
//        PrintWriter pw = new PrintWriter(new BufferedWriter(fileWriter));
//        pw.println(headerRow);
//        CloudUnit cloud = networkArchitecture.getCloudRoot();
//        String asCsv = turnDeviceIntoCsv(cloud);
//        pw.println(asCsv);
//        for (EdgeServer edgeServer : networkArchitecture.getEdgeServers()) {
//            asCsv = turnDeviceIntoCsv(edgeServer);
//            pw.println(asCsv);
//        }
//
//        for (BaseStation bs : networkArchitecture.getBaseStations()) {
//            asCsv = turnDeviceIntoCsv(bs);
//            pw.println(asCsv);
//        }
//
//        for (UserEquipment userEquipment : networkArchitecture.getUserEquipments()) {
//            asCsv = turnDeviceIntoCsv(userEquipment);
//            pw.println(asCsv);
//        }
//        pw.close();
//    }
//
//    private String turnDeviceIntoCsv(Host host) {
//        // id, parent_id, storage, latitude, longitude, bandwidth_uplink_for_children, bandwidth_downlink_for_children, bandwidth_siblings
//        final int hostId = host.getId();
//        final int parentId = host.getParentUnit() == null ? 0 : host.getParentUnit().getId();
//        final double latitude = host.getLocation() == null ? 0 : host.getLocation().getLatitude();
//        final double longitude = host.getLocation() == null ? 0 : host.getLocation().getLongitude();
//        double bw_uplink_children = 0;
//        double bw_downlink_children = 0;
//        double bw_siblings = 0;
//        if (host instanceof RelayingHost) {
//            RelayingHost relayingHost = (RelayingHost) host;
//            bw_uplink_children = relayingHost.getTotalUplinkBwForChildren();
//            bw_downlink_children = relayingHost.getTotalDownlinkBwForChildren();
//        }
//
//        if (host instanceof EdgeServer) {
//            bw_siblings = ((EdgeServer) host).getBandwidthForSiblings();
//        }
//
//        return String.format("%s,%d,%d,%s,%s,%s,%s,%s", HierarchyUtils.getHostTypeAsString(host),
//                hostId, parentId, latitude, longitude, bw_uplink_children, bw_downlink_children, bw_siblings);
//    }
//}
