package edu.ucc.statisticscollection;

import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

/***
 * Models a content request in a host for statistical purposes.
 */
public abstract class Request {
    protected final Host currentHost;
    protected final Content referredContent;
    protected double requestTimestamp;
    protected double firstChunkReceivedAt;
    protected double completedAt;
    protected int requestId;
    protected long receivedChunks;
    protected long transmittedChunksUpwards;
    protected long transmittedChunksDownwards;
    protected long transmittedChunksSiblings;
    protected long totalChunks;

    public Request(int requestId, Host currentHost, Content referredContent, double requestTimestamp, long totalChunks) {
        this.requestId = requestId;
        this.currentHost = currentHost;
        this.referredContent = referredContent;
        this.requestTimestamp = requestTimestamp;
        this.totalChunks = totalChunks;
        this.firstChunkReceivedAt = 0;
        this.firstChunkReceivedAt = 0;
        this.completedAt = 0;

        this.receivedChunks = 0;
        this.transmittedChunksUpwards = 0;
        this.transmittedChunksDownwards = 0;
        this.transmittedChunksSiblings = 0;
    }

    public void setFirstChunkReceivedAt(double firstChunkReceivedAt) {
        this.firstChunkReceivedAt = firstChunkReceivedAt;
    }

    public void setCompletedAt(double completedAt) {
        this.completedAt = completedAt;
    }

    public double getCompletedAt() {
        return completedAt;
    }

    public double getFirstChunkReceivedAt() {
        return firstChunkReceivedAt;
    }

    public double getRequestTimestamp() {
        return requestTimestamp;
    }

    public int getRequestId() {
        return requestId;
    }

    public Content getReferredContent() {
        return referredContent;
    }

    public void increaseTransmittedChunksUpwards() {
        this.transmittedChunksUpwards++;
    }

    public void increaseTransmittedChunksDownwards() {
        this.transmittedChunksDownwards++;
    }

    public void increaseTransmittedChunksSiblings() {
        this.transmittedChunksSiblings++;
    }

    public long getTransmittedChunksSiblings() {
        return transmittedChunksSiblings;
    }

    public void increaseReceivedChunks() {
        this.receivedChunks++;
    }

    public long getReceivedChunks() {
        return receivedChunks;
    }

    public long getTransmittedChunksDownwards() {
        return transmittedChunksDownwards;
    }
}

