package edu.ucc.statisticscollection;

public class FileDownloadLatencyRecord {
    private final int requestId;
    private final int idUe;
    private final String contentDescription;
    private final long contentSize;
    private final double requestTime;
    private final double completedAt;
    private final double latencyFirstChunk;
    private final double completionTime;
    private final double speed;

    FileDownloadLatencyRecord(int requestId, int idUe, String contentDescription, long contentSize, double requestTime,
                              double completedAt, double latencyFirstChunk, double completionTime, double speed) {
        this.requestId = requestId;
        this.idUe = idUe;
        this.contentDescription = contentDescription;
        this.contentSize = contentSize;
        this.requestTime = requestTime;
        this.completedAt = completedAt;
        this.latencyFirstChunk = latencyFirstChunk;
        this.completionTime = completionTime;
        this.speed = speed;
    }

    public int getRequestId() {
        return requestId;
    }

    public double getLatencyFirstChunk() {
        return latencyFirstChunk;
    }

    public double getSpeed() {
        return speed;
    }

    @Override
    public String toString() {
        return String.format("%s\t %s \t\t %s\t\t\t %s\t\t   %.12f \t %.12f \t %.12f \t  %.12f \t  %.3f",
                requestId, idUe, contentDescription, contentSize, requestTime, completedAt,
                latencyFirstChunk, completionTime, speed);
    }

    public String toCsv() {
        return String.format("%s,%s,%s,%s,%.12f,%.12f,%.12f,%.12f,%.3f",
                requestId, idUe, contentDescription, contentSize, requestTime, completedAt,
                latencyFirstChunk, completionTime, speed);
    }

    public static String getCsvHeader() {
        return "req,ue,content,contentSize,reqTime,completedAt,latencyFirstChunk,completionTime,speed";
    }
}