package edu.ucc.statisticscollection;

public class DataRequestFromUELatencyRecord {
    private final int requestId;
    private final int requestingUeId;
    private final int sourceUeId;
    private final String contentDescription;
    private final long contentSize;
    private final double requestTime;
    private final double completedAt;
    private final double latencyFirstChunk;
    private final double completionTime;
    private final double speed;

    public DataRequestFromUELatencyRecord(int requestId, int requestingUeId, int sourceUeId, String contentDescription, long contentSize, double requestTime, double completedAt, double latencyFirstChunk, double completionTime, double speed) {
        this.requestId = requestId;
        this.requestingUeId = requestingUeId;
        this.sourceUeId = sourceUeId;
        this.contentDescription = contentDescription;
        this.contentSize = contentSize;
        this.requestTime = requestTime;
        this.completedAt = completedAt;
        this.latencyFirstChunk = latencyFirstChunk;
        this.completionTime = completionTime;
        this.speed = speed;
    }

    public double getLatencyFirstChunk() {
        return latencyFirstChunk;
    }

    public double getSpeed() {
        return speed;
    }

    @Override
    public String toString() {
        return String.format("%s\t %s \t\t\t %s \t\t %s\t\t\t %s\t\t   %.12f \t %.12f \t %.12f \t  %.12f \t  %.3f",
                requestId, requestingUeId, sourceUeId, contentDescription, contentSize, requestTime,
                completedAt, latencyFirstChunk, completionTime, speed);
    }
}
