package edu.ucc.network.devices;

import edu.ucc.core.events.simulationevents.RequestEvent;
import edu.ucc.core.transport.chunks.ContentChunk;

import java.util.List;

import static edu.ucc.utils.Logging.printWarning;


public class UserEquipment extends Host {
    public UserEquipment(int id, long storage, Location location, int mtu) {
        super(id, storage, location, mtu);
    }

    @Override
    public void setParentUnit(Host newParent) {
        if (newParent instanceof BaseStation) {
            this.setParent(newParent);
        } else {
            throw new RuntimeException("A User Equipment's parent must be a Base Station object");
        }
    }

    @Override
    public String toString() {
        return String.format("UserEquipment %s with BS %s as parent", id, parentUnit != null ? parentUnit.id : "none");
    }

    public void addChunksForNewRequest(BaseStation nextHopBS, RequestEvent requestEvent, int totalChunks, int chunkSize) {
        for (int chunkNum = 0; chunkNum < totalChunks; chunkNum++) {
            addChunkForTransmissionToParent(new ContentChunk(requestEvent, chunkNum, totalChunks, chunkSize));
            // this.uplinkChunksBuffer.addToBuffer(nextHopBS, new ContentChunk(requestEvent, chunkNum, totalChunks, chunkSize));
        }
    }

    public void reSendChunksForNewParent(List<ContentChunk> pendingChunksInPreviousParent) {
        if (pendingChunksInPreviousParent.size() > 1) {
            printWarning("Chunks waiting ACK from previous BS parent are more than 1!!");
        }

        if (pendingChunksInPreviousParent.size() > 0) {
            pendingChunksInPreviousParent.forEach(this::addChunkForTransmissionToParent);
            sendChunksToParentAfterHandover();
        }
    }

    @Override
    public String getTypeAsString() {
        return "UE";
    }
}
