package edu.ucc.network.devices;

import edu.ucc.core.PrefetchManager;
import edu.ucc.core.Simulation;
import edu.ucc.core.events.simulationevents.PrefetchRequestEvent;
import edu.ucc.core.events.simulationevents.RequestEvent;
import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.core.transport.routing.RoutingTable;
import edu.ucc.testbedinterface.ITestbedEvents;

import java.util.List;

public class CloudUnit extends AdvancedHost {
    public CloudUnit(int id, long storage, Location location, int mtu) {
        super(id, storage, location, mtu);
        setPrefetchManager(new PrefetchManager() {
            @Override
            public void onPrefetchRequestReceived(Host host, PrefetchRequestEvent prefetchRequestEvent) {
                final ITestbedEvents eventsBroker = Simulation.getInstance().getEventsBroker();
                eventsBroker.onPrefetchRequestReceived(host, prefetchRequestEvent);
            }
        });
    }

    @Override
    public String toString() {
        return String.format("CloudUnit %s with %s children Edge Servers", id, childrenUnits.size());
    }

    @Override
    public void setParentUnit(Host newParent) {
        throw new IllegalArgumentException("Not implemented yet, CloudUnits can't have a parent unit.");
    }

    @Override
    public void setChildrenUnits(List<Host> newChildren) {
        for (Host h : newChildren) {
            if (!(h instanceof EdgeServer)) {
                throw new IllegalArgumentException("One of the new children is not of type EdgeServer");
            }
        }

        this.assignChildren(newChildren);
    }

    public EdgeServer findEdgeServerForBS(BaseStation targetBS) {
        final List<Host> childrenUnits = this.getChildrenUnits();
        for (Host edge : childrenUnits) {
            EdgeServer edgeServer = (EdgeServer) edge;
            if (edgeServer.containsBaseStation(targetBS)) {
                return edgeServer;
            }
        }

        throw new RuntimeException(String.format("No ES contains the BS %s", targetBS.getId()));
    }

    public void updateEdgeServerPartInRoutingTable(UserEquipment userEquipment, EdgeServer targetES) {
        final RoutingTable routingTable = Simulation.getInstance().getNetworkArchitecture().getRoutingTable();
        routingTable.updateEdgePartForUserEquipment(userEquipment, targetES);
    }

    public void reSendChunksFromSourceES(EdgeServer targetES, List<ContentChunk> pendingChunksInSourceES) {
        if (pendingChunksInSourceES.size() > 0) {
            addChunksToDownlinkBuffer(targetES, pendingChunksInSourceES);
            sendChunksDownwardsAfterHandover();
        }
    }

    @Override
    public void addChunksForTransmissionToChild(Host nextHopHost, RequestEvent requestEvent, int totalChunks, int chunkSize) {
        if (nextHopHost instanceof EdgeServer) {
            for (int chunkNum = 0; chunkNum < totalChunks; chunkNum++) {
                this.downlinkChunksBuffer.addToBuffer(nextHopHost,
                        new ContentChunk(requestEvent, chunkNum, totalChunks, chunkSize));
            }
        } else throw new RuntimeException(String.format("NextHop for downlink should be an ES (An %s was specified)",
                nextHopHost.getTypeAsString()));
    }

    @Override
    public String getTypeAsString() {
        return "Cloud";
    }
}
