package edu.ucc.network.architecture;

import edu.ucc.network.devices.Location;

import java.util.ArrayList;
import java.util.List;

public class TopologyMakerMesh {
    private double bsRange;
    private int columns;
    private int rows;

    public TopologyMakerMesh(int columns, int rows, double bsRange) {
        this.columns = columns;
        this.rows = rows;
        this.bsRange = bsRange;
    }

    public List<List<Location>> createLocationsForBSs() {
        List<List<Location>> baseStations = new ArrayList<>();
//         factor_y = 2 * math.sqrt(0.75) * bsRange # OPTION A
        double factorY = Math.sqrt(3 * bsRange * bsRange); // # OPTION B
        double factorX = (bsRange * 3 / 2);
        double offsetY;
        double x, y;
        for (int column = 0; column < columns; column++) {
            x = column * factorX;
            if ((column % 2) == 0) offsetY = 0;
            else offsetY = Math.sqrt(0.75 * bsRange * bsRange);


            List<Location> baseStationsThisColumn = new ArrayList<>();
            for (int row = 0; row < rows; row++) {
                y = offsetY + (row * factorY); // Option A
//                y = row * factorY;  // OPTION B
                Location location = new Location(x, y);
                baseStationsThisColumn.add(location);
            }

            baseStations.add(baseStationsThisColumn);
        }

        return baseStations;
    }
}
