package edu.ucc.network.architecture;

import edu.ucc.network.devices.EdgeServer;
import edu.ucc.network.devices.Host;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/***
 * This class will assign edge siblings in a one.vs.all approach
 */
public class EdgeServersSiblingsMeshAssigner extends EdgeServersSiblingsAssigner {
    public EdgeServersSiblingsMeshAssigner(List<EdgeServer> edgeServers) {
        super(edgeServers);
    }

    @Override
    public void assignSiblings() {
        for (EdgeServer edgeServer : this.edgeServers) {
            final Predicate<EdgeServer> predicate = es -> es != edgeServer;
            List<Host> otherServersAsHost = edgeServers.stream().filter(predicate).collect(Collectors.toList());
            edgeServer.setSiblingUnits(otherServersAsHost);
        }
    }
}
