package edu.ucc.network.architecture;

import edu.ucc.network.devices.EdgeServer;
import edu.ucc.network.devices.Host;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EdgeServersSiblingsDistanceThresholdAssigner extends EdgeServersSiblingsAssigner {

    private final double distanceThreshold;

    public EdgeServersSiblingsDistanceThresholdAssigner(List<EdgeServer> edgeServers, double distanceThreshold) {
        super(edgeServers);
        this.distanceThreshold = distanceThreshold;
    }

    @Override
    public void assignSiblings() {
        for (EdgeServer edgeServer : this.edgeServers) {
            final Predicate<EdgeServer> predicate = es -> es != edgeServer && edgeServer.getLocation().distanceTo(es.getLocation()) < distanceThreshold;
            List<Host> otherServersAsHost = edgeServers.stream().filter(predicate).collect(Collectors.toList());
            edgeServer.setSiblingUnits(otherServersAsHost);
        }
    }
}
