package edu.ucc.entities;

/**
 * Class to represent the files existing in the cloud and that can be requested by UEs. Files are assumed static (their
 * content never changes) and because of this they can be cached at edge servers for later reuse.
 */
public class File extends Content {
    private final String uri;

    public File(String uri, long size) {
        super(uri, size, true);
        this.uri = uri;
    }

    public String getUri() {
        return uri;
    }

    @Override
    public String getDescription() {
        return uri.substring(uri.lastIndexOf('/') + 1);
    }

    @Override
    public String toString() {
        return getUri() + ", " + getSize() + " bytes (" + (getSize() * 8) + " bits)";
    }
}
