package edu.ucc.entities;

/**
 * Base class to represent pretty much anything that is transmitted by the network and is not a file.
 * This includes the {@link IoTData} and other types of data for message passing in our solution (see the solution
 * module to study how this class is exploited there).
 */
public abstract class Data extends Content {
    private final double timestamp;

    public Data(long size, double timestamp, boolean cachable) {
        super(null, size, cachable);
        this.timestamp = timestamp;
    }

    public double getTimestamp() {
        return timestamp;
    }
}
