package edu.ucc.entities;

/**
 * Base class for all the different types of Content that can be transmitted by the network simulator.
 * See {@link File} and {@link Data} and derived classes.
 */
public abstract class Content {
    private String URI;
    private final long id;
    private final long size;
    private final boolean cachable;
    private static long CURRENT_ID = 0;

    /**
     * Base constructor
     *
     * @param uri      The content's URI
     * @param size     The size of the content IN BYTES (output representation is in bits)
     * @param cachable Whether the content is cachable or not
     */
    public Content(String uri, long size, boolean cachable) {
        this.id = CURRENT_ID++;
        this.URI = uri;
        this.size = size;
        this.cachable = cachable;
    }

    public long getId() {
        return id;
    }

    public long getSize() {
        return size;
    }

    public String getURI() {
        return URI;
    }

    public void setURI(String URI) {
        this.URI = URI;
    }

    public abstract String getDescription();

    public boolean isCachable() {
        return cachable;
    }
}
