package edu.ucc.core.transport.routing;

import edu.ucc.network.devices.BaseStation;
import edu.ucc.network.devices.CloudUnit;
import edu.ucc.network.devices.EdgeServer;
import edu.ucc.network.devices.UserEquipment;

/***
 * This class models an entry in the {@link RoutingTable}
 */
public class RoutingEntry {
    private CloudUnit cloudUnit;
    private EdgeServer edgeServer;
    private BaseStation baseStation;
    private UserEquipment userEquipment;

    public RoutingEntry(CloudUnit cloudUnit, EdgeServer edgeServer, BaseStation baseStation, UserEquipment userEquipment) {
        this.cloudUnit = cloudUnit;
        this.edgeServer = edgeServer;
        this.baseStation = baseStation;
        this.userEquipment = userEquipment;
    }

    public void updateBaseStationPart(BaseStation baseStation) {
        this.baseStation = baseStation;
    }

    public void updateEdgeServerPart(EdgeServer edgeServer) {
        this.edgeServer = edgeServer;
    }

    public EdgeServer getEdgeServerPartInRoute() {
        return edgeServer;
    }

    public BaseStation getBaseStationPartInRoute() {
        return baseStation;
    }

    public UserEquipment getUserEquipmentPartInRoute() {
        return userEquipment;
    }
}
