package edu.ucc.core.transport.chunks;

import edu.ucc.core.events.simulationevents.RequestEvent;
import edu.ucc.network.devices.Host;

import java.io.Serializable;

public class ContentChunk implements Serializable {
    private final RequestEvent requestEvent;
//    private final Content referredContent;
    private final int chunkNumber;
    private final int totalChunks;
    private final int chunkSize;

    public ContentChunk(RequestEvent requestEvent, int chunkNumber, int totalChunks, int chunkSize) {
        this.requestEvent = requestEvent;
//        this.referredContent = referredContent;
        this.chunkNumber = chunkNumber;
        this.totalChunks = totalChunks;
        this.chunkSize = chunkSize;
    }

//    public Content getReferredContent() {
//        return referredContent;
//    }

    public int getChunkNumber() {
        return chunkNumber;
    }

    public int getTotalChunks() {
        return totalChunks;
    }

    public int getChunkSize() {
        return chunkSize;
    }

    public RequestEvent getRequestEvent() {
        return requestEvent;
    }

    public boolean isLastChunk() {
        return this.chunkNumber == this.totalChunks - 1;
    }

    public boolean isFirstChunk() {
        return this.chunkNumber == 0;
    }

    public boolean isThisDestinationHost(Host host) {
        return requestEvent.getContentDestinationHost() == host;
    }
}

