package edu.ucc.core.simpleimplementations;

import edu.ucc.core.HandoverManager;
import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.BaseStation;
import edu.ucc.network.devices.Host;
import edu.ucc.network.devices.LocationFix;
import edu.ucc.network.devices.UserEquipment;
import edu.ucc.utils.TransmissionUtils;

import java.util.List;

public class SimpleUserEquipmentHandoverManager implements HandoverManager {
    @Override
    public void onUserEquipmentHandover(Host host, HandoverEvent handoverEvent) {
        UserEquipment userEquipment = handoverEvent.getMovingUE();
        BaseStation targetBS = handoverEvent.getTargetBS();
        BaseStation sourceBS = handoverEvent.getSourceBS();
        LocationFix location = handoverEvent.getLocationFix();

//        if (!areNeighbourBaseStations(sourceBS, targetBS)) {
//            printWarning(String.format("BS %s and %s are not neighbours BSs", sourceBS.getId(), targetBS.getId()));
//        }

        // We notify target BS
        // The reason why is bc it belongs to the ES that at the moment has the chunks to be transmitted to the UE.
        double timestamp = handoverEvent.getTimestamp();
        HandoverEvent newHandoverEvent = new HandoverEvent(userEquipment, targetBS, timestamp, sourceBS, targetBS,
                userEquipment, null, null, location);
        targetBS.processEvent(newHandoverEvent);

        // We resend any pending chunk in the ackBuffer and those in the pendingBuffer
        final List<ContentChunk> pendingAckChunksInUE = userEquipment.getPendingAckChunks(sourceBS);
        final List<ContentChunk> pendingChunksInUE = userEquipment.getPendingChunks(sourceBS);

        userEquipment.removeChunksWaitingAckFromPreviousParent(sourceBS);
        userEquipment.removePendingChunksFromPreviousParent(sourceBS);

        final List<ContentChunk> chunksToRetransmit = TransmissionUtils.fuseListsOfChunks(pendingChunksInUE, pendingAckChunksInUE);

        userEquipment.reSendChunksForNewParent(chunksToRetransmit);
    }

    private boolean areNeighbourBaseStations(BaseStation sourceBS, BaseStation targetBS) {
        final double distance = sourceBS.getLocation().distanceTo(targetBS.getLocation());
        // final double distanceDiff = Math.abs(distance - sourceBS.getRange());
        final int hysteresis = 3;
        return distance < (2 * sourceBS.getRange()) + hysteresis;
    }
}
