package edu.ucc.core.simpleimplementations;

import edu.ucc.core.HandoverManager;
import edu.ucc.core.Simulation;
import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.*;

import java.util.List;

import static edu.ucc.utils.TransmissionUtils.fuseListsOfChunks;

public class SimpleEdgeHandoverManager implements HandoverManager {
    //        private int i=0;
    @Override
    public void onUserEquipmentHandover(Host host, HandoverEvent handoverEvent) {
        final EdgeServer edgeServer = (EdgeServer) host;
        final CloudUnit cloudUnit = (CloudUnit) (edgeServer.getParentUnit());
        final BaseStation targetBS = handoverEvent.getTargetBS();
        final BaseStation sourceBS = handoverEvent.getSourceBS();
        final double timestamp = handoverEvent.getTimestamp();
        final LocationFix locationFix = handoverEvent.getLocationFix();

        // Notice how pending chunks are bubbling up in the hierarchy until it reaches the host that should handle them.
        final List<ContentChunk> pendingChunksInSourceBS = handoverEvent.getPendingChunksInHost();
        final List<ContentChunk> pendingAckChunksInSourceBS = handoverEvent.getPendingAckChunksInHost();
        final UserEquipment movingUE = handoverEvent.getMovingUE();

        // Regardless of whether the UE will be served by the same Edge Server, we need to update the target BS in route
        edgeServer.updateBSInRoutingTable(movingUE, targetBS);

        final List<ContentChunk> pendingChunksInES = edgeServer.getPendingChunksForUE(movingUE.getId());
        final List<ContentChunk> pendingAckChunksInES = edgeServer.getPendingAckChunksForUE(movingUE.getId());
        edgeServer.removePendingChunksForMovingUE(movingUE);
        edgeServer.removeChunksWaitingAckForMovingUE(movingUE);

        if (handoverEvent.isIntraHandover()) {
            final List<ContentChunk> chunksToRetransmit = fuseListsOfChunks(pendingAckChunksInSourceBS,
                    pendingChunksInSourceBS,
                    pendingChunksInES,
                    pendingAckChunksInES);
            edgeServer.reSendChunksFromSourceBS(targetBS, chunksToRetransmit);
            //            System.out.println(String.format("Handover %s at es %s", (i++), edgeServer.getId()));
            Simulation.getInstance().getEventsBroker().onUserEquipmentHandover(edgeServer, handoverEvent);
        } else {
            List<ContentChunk> pendingChunks = fuseListsOfChunks(pendingChunksInSourceBS, pendingChunksInES);
            List<ContentChunk> pendingAckChunks = fuseListsOfChunks(pendingAckChunksInSourceBS, pendingAckChunksInES);

            HandoverEvent newHandoverEvent = new HandoverEvent(edgeServer, cloudUnit, timestamp, sourceBS, targetBS,
                    movingUE, pendingChunks, pendingAckChunks, locationFix);

            cloudUnit.processEvent(newHandoverEvent);
        }
    }
}
