package edu.ucc.core.events.simulationevents;

import edu.ucc.network.devices.*;

import static edu.ucc.utils.TransmissionUtils.*;

public abstract class TestbedEvent extends SimulationEvent  {
    protected final Host eventOriginHost;
    protected final Host eventDestinationHost;

    public TestbedEvent(Host eventOriginHost, Host eventDestinationHost, double timestamp) {
        super(timestamp);
        this.eventOriginHost = eventOriginHost;
        this.eventDestinationHost = eventDestinationHost;
    }

    public Host getEventOriginHost() {
        return eventOriginHost;
    }

    public Host getEventDestinationHost() {
        return eventDestinationHost;
    }

    /**
     * Finds out the direction the event is following.
     * @return UPWARDS_DIRECTION if in the upwards direction, DOWNWARDS_DIRECTION if in the downwards direction,
     * or SAME_LEVEL_DIRECTION if in the same level (Edge Server inter communication)
     */
    public int getEventDirection() {
        final Host originHost = getEventOriginHost();
        final Host destinationHost = getEventDestinationHost();
        int result = SAME_LEVEL_DIRECTION;
        if (destinationHost instanceof UserEquipment) {
            result = originHost == null ? UPWARDS_DIRECTION : DOWNWARDS_DIRECTION;
        }
        if (destinationHost instanceof BaseStation)
            result = originHost instanceof UserEquipment ? UPWARDS_DIRECTION : DOWNWARDS_DIRECTION;
        if (destinationHost instanceof EdgeServer) {
            if (originHost instanceof BaseStation) result = UPWARDS_DIRECTION;
            else if (originHost instanceof CloudUnit)
                result = DOWNWARDS_DIRECTION;
        }
        if (destinationHost instanceof CloudUnit) result = originHost != null ? UPWARDS_DIRECTION : DOWNWARDS_DIRECTION;
        return result;
    }

    @Override
    public void execute() {
        eventDestinationHost.processEvent(this);
    }
}
