package edu.ucc.core.events.simulationevents;

public abstract class SimulationEvent implements Comparable<SimulationEvent> {
    private final long eventId;
    private static long eventsCounter;
    protected final double timestamp;

    public SimulationEvent(double timestamp) {
        this.eventId = ++eventsCounter;
        this.timestamp = timestamp;
    }

    public double getTimestamp() {
        return timestamp;
    }

    @Override
    public int compareTo(final SimulationEvent evt) {
        if (evt == null) {
            return 1;
        } else if (this.getTimestamp() < evt.getTimestamp()) {
            return -1;
        } else if (this.getTimestamp() > evt.getTimestamp()) {
            return 1;
        } else if (this == evt) {
            return 0;
        } else {
            return 1;
        }
    }

    public abstract void execute();
}
