package edu.ucc.core.events.simulationevents;

import edu.ucc.entities.File;
import edu.ucc.network.devices.Host;

public final class PushFileRequestEvent extends PushRequestEvent {
    public PushFileRequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                                File referredContent, Host pushInitiatorHost, Host pushDestinationHost, PushReason reason) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp, pushInitiatorHost, pushDestinationHost, referredContent, reason);
    }

    @Override
    public File getReferredContent() {
        return (File) super.getReferredContent();
    }

    @Override
    public String toString() {
        return "[PushFileRequestEvent] " + super.toString();
    }
}
