package edu.ucc.core.events.simulationevents;

import edu.ucc.entities.Data;
import edu.ucc.network.devices.Host;

public class PushDataRequestEvent extends PushRequestEvent {

    public PushDataRequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                                Data pushedData, Host pushInitiatorHost, Host pushDestinationHost, PushReason reason) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp, pushInitiatorHost,
                pushDestinationHost, pushedData, reason);
    }

    @Override
    public Data getReferredContent() {
        return (Data) super.getReferredContent();
    }

    @Override
    public String toString() {
        return String.format("[PushDataRequestEvent] at %s %s for %s from %s %s towards %s %s, @ %s",
                eventDestinationHost.getTypeAsString(), eventDestinationHost.getId(),
                referredContent.getDescription(),
                pushInitiatorHost.getTypeAsString(), pushInitiatorHost.getId(),
                pushDestinationHost.getTypeAsString(), pushDestinationHost.getId(),
                timestamp
        );
    }
}
