package edu.ucc.core.events.simulationevents;

import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

public abstract class PullRequestEvent extends RequestEvent {
    // this is the requesting host
    private final Host pullInitiatorHost;
    // this is the content location host, the one that has the content and that will receive the call
    private final Host pullDestinationHost;

    public PullRequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                            Host pullInitiatorHost, Host pullDestinationHost, Content referredContent) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp, referredContent);
        this.pullInitiatorHost = pullInitiatorHost;
        this.pullDestinationHost = pullDestinationHost;
    }

    public PullRequestEvent(int requestId, int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp,
                            Host pullInitiatorHost, Host pullDestinationHost, Content referredContent) {
        super(requestId, appId, eventOriginHost, eventDestinationHost, timestamp, referredContent);
        this.pullInitiatorHost = pullInitiatorHost;
        this.pullDestinationHost = pullDestinationHost;
    }

    public Host getPullDestinationHost() {
        return pullDestinationHost;
    }

    public Host getPullInitiatorHost() {
        return pullInitiatorHost;
    }

    @Override
    public Host getContentLocationHost() {
        return pullDestinationHost;
    }

    @Override
    public Host getContentDestinationHost() {
        return pullInitiatorHost;
    }

    public abstract PullRequestEvent createEventForNextHop(Host nextHop, double timeToReachNextHop);
}




