package edu.ucc.core.events.simulationevents;

import edu.ucc.entities.Data;
import edu.ucc.network.devices.Host;
import edu.ucc.network.devices.UserEquipment;

public final class PullDataRequestEvent extends PullRequestEvent {

    public PullDataRequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp, Host requestingHost,
                                UserEquipment dataSourceUE, Data referredData) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp, requestingHost, dataSourceUE, referredData);
    }

    public PullDataRequestEvent(int requestId, int appId, Host eventOriginHost, Host eventDestinationHost, double timestamp, Host requestingHost,
                                UserEquipment dataSourceUE, Data referredData) {
        super(requestId, appId, eventOriginHost, eventDestinationHost, timestamp, requestingHost, dataSourceUE, referredData);
    }

    @Override
    public Data getReferredContent() {
        return (Data) super.getReferredContent();
    }

    @Override
    public UserEquipment getPullDestinationHost() {
        return (UserEquipment) super.getPullDestinationHost();
    }

    @Override
    public PullDataRequestEvent createEventForNextHop(Host nextHop, double timeToNextHop) {
        double eventTime = this.getTimestamp();
        double timestamp = eventTime + timeToNextHop;
        final Host originHost = this.getEventDestinationHost();
        final UserEquipment ueDataSource = this.getPullDestinationHost();
        final int requestId = this.getRequestId();
        final int appId = this.getAppId();
        final Host initiatorHost = getPullInitiatorHost();
        final Data referredData = getReferredContent();

        return new PullDataRequestEvent(requestId, appId, originHost, nextHop, timestamp, initiatorHost,
                ueDataSource, referredData);
    }

    @Override
    public String toString() {
        return "[PullDataRequestEvent] " + super.toString();
    }
}
