package edu.ucc.core.events.simulationevents;

import edu.ucc.entities.File;
import edu.ucc.network.devices.Host;

public final class PrefetchRequestEvent extends RequestEvent {
    private final double prefetchTimestamp;
    private final Host prefetchInitiatorHost;
    private final int[] destinationHostsIds;
    private final File fileToPrefetch;
    private final boolean targetingEdgeServers;

    public PrefetchRequestEvent(int appId, Host eventOriginHost, Host eventDestinationHost, Host prefetchInitiatorHost, double timestamp,
                                File fileToPrefetch, int[] destinationHostsIds, boolean targetingEdgeServers, double prefetchTimestamp) {
        super(appId, eventOriginHost, eventDestinationHost, timestamp, fileToPrefetch);
        this.fileToPrefetch = fileToPrefetch;
        this.prefetchTimestamp = prefetchTimestamp;
        this.destinationHostsIds = destinationHostsIds;
        this.targetingEdgeServers = targetingEdgeServers;
        this.prefetchInitiatorHost = prefetchInitiatorHost;
    }

    public double getPrefetchTimestamp() {
        return prefetchTimestamp;
    }

    public int[] getDestinationHostsIds() {
        return destinationHostsIds;
    }

    public File getFileToPrefetch() {
        return fileToPrefetch;
    }

    public boolean isTargetingEdgeServers() {
        return targetingEdgeServers;
    }

    @Override
    public Host getContentLocationHost() {

        return prefetchInitiatorHost;
    }

    @Override
    public Host getContentDestinationHost() {
        return null;
    }

    @Override
    public String toString() {
        return "[PrefetchRequestEvent] " + super.toString();
    }
}
