package edu.ucc.core.events.simulationevents;

import edu.ucc.core.transport.chunks.ContentChunk;
import edu.ucc.network.devices.Host;

public class ChunkReceivedEvent extends TestbedEvent {
    private final ContentChunk contentChunk;

    public ChunkReceivedEvent(Host processingHost, Host destinationHost, double timestamp, ContentChunk contentChunk) {
        super(processingHost, destinationHost, timestamp);
        this.contentChunk = contentChunk;
    }

    public ContentChunk getChunk() {
        return contentChunk;
    }

    @Override
    public String toString() {
        final ContentChunk chunk = getChunk();
        final RequestEvent request = chunk.getRequestEvent();
        final Host host = getEventDestinationHost();
        return String.format("At %s %s, received chunk %s/%s, for request %s @ %s", host.getTypeAsString(),
                host.getId(), chunk.getChunkNumber(), chunk.getTotalChunks() - 1,
                request.getRequestId(), getTimestamp());
    }
}

