package core.processingchain.preprocessors.pool;

import core.app.App;
import core.processingchain.metadata.pool.BaseMetadata;
import core.processingchain.preprocessors.PPOutcome;
import core.processingchain.preprocessors.PreProcessor;
import edu.ucc.core.events.simulationevents.PushRequestEvent;

public class PreProcessorPushRequest extends PreProcessor<PushRequestEvent> {

    @Override
    public PPOutcome execute(App app, PushRequestEvent pushRequestEvent, BaseMetadata metadata, double timestamp) {
        // A constant for preprocessing delay for push requests
        double preprocessingDelay = 0.0001;
        double preProcessingTimestamp = preprocessingDelay + timestamp;//pushRequestEvent.getTimestamp();
        return new PPOutcomePushRequest(app.getAppId(), pushRequestEvent, preProcessingTimestamp, metadata, pushRequestEvent);
    }
}
