package core.processingchain.preprocessors.pool;

import core.app.App;
import core.processingchain.metadata.pool.BaseMetadata;
import core.processingchain.preprocessors.PPOutcome;
import core.processingchain.preprocessors.PreProcessor;
import edu.ucc.core.events.simulationevents.PullRequestEvent;

public class PreProcessorPullRequest extends PreProcessor<PullRequestEvent> {

    @Override
    public PPOutcome execute(App app, PullRequestEvent pullRequestEvent, BaseMetadata metadata, double timestamp) {
        // A constant for preprocessing delay for pull requests
        double preprocessingDelay = 0.0001;
        double preProcessingTimestamp = preprocessingDelay + timestamp; // pullRequestEvent.getTimestamp();
        return new PPOutcomePullRequest(app.getAppId(), pullRequestEvent, preProcessingTimestamp, metadata, pullRequestEvent);
    }
}
