package core.processingchain.preprocessors;

import core.processingchain.metadata.pool.BaseMetadata;
import edu.ucc.core.events.simulationevents.ObservableTestbedEvent;

public abstract class PPOutcome {
    private final Object outcome;
    private final BaseMetadata testbedEventMetadata;
    private final ObservableTestbedEvent observableTestbedEvent;
    private final double timestamp;
    private final int appId;

    public PPOutcome(int appId, Object outcome, double timestamp, BaseMetadata testbedEventMetadata, ObservableTestbedEvent observableTestbedEvent) {
        this.appId = appId;
        this.outcome = outcome;
        this.timestamp = timestamp;
        this.testbedEventMetadata = testbedEventMetadata;
        this.observableTestbedEvent = observableTestbedEvent;
    }

    public Object getOutcome() {
        return outcome;
    }

    public BaseMetadata getTestbedEventMetadata() {
        return testbedEventMetadata;
    }

    public ObservableTestbedEvent getObservableTestbedEvent() {
        return observableTestbedEvent;
    }

    public int getAppId() {
        return appId;
    }

    public double getTimestamp() {
        return timestamp;
    }
}
