package core.processingchain.metadata.pool;

import core.processingchain.actions.policies.BasePolicy;
import core.processingchain.events.detectors.BaseEventDetector;
import core.processingchain.preprocessors.PreProcessor;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AppMetadata extends BaseMetadata {
    private final String name;
    private final String uriBase;
    private final long allocatedSpace;

    private final Map<Type, PreProcessor> preProcessors;
    private final Map<Type, BaseEventDetector> eventDetectors;
    private final List<BasePolicy> policies;


    public AppMetadata(int appId, String name, String uriBase, long allocatedSpace,
                       Map<Type, PreProcessor> preProcessors, Map<Type, BaseEventDetector> eventDetectors,
                       List<BasePolicy> policies) {
        super(appId);
        this.name = name;
        this.uriBase = uriBase;
        this.allocatedSpace = allocatedSpace;
        this.preProcessors = preProcessors;
        this.eventDetectors = eventDetectors;
        this.policies = policies;
    }
}
