package core.processingchain.metadata.extractor;

import core.processingchain.metadata.pool.BaseMetadata;
import core.processingchain.metadata.pool.RequestMetadata;
import edu.ucc.core.events.simulationevents.RequestEvent;

import static edu.ucc.utils.Logging.printDebug;

public class RequestMetadataExtractor extends MetadataExtractor<RequestEvent> {
    @Override
    public BaseMetadata extractMetadata(RequestEvent solutionEvent) {
        printDebug(String.format("RequestMetadataExtractor: extracting metadata from request %s",
                solutionEvent.getRequestId()));
        return new RequestMetadata(
                solutionEvent.getAppId(),
                solutionEvent, solutionEvent.getTimestamp()
        );
    }
}
