package core.processingchain.metadata;

import core.processingchain.metadata.pool.BaseMetadata;

import java.util.ArrayList;
import java.util.List;

public class MetadataAPI {
    MetadataRepository metadataRepository;

    public MetadataAPI() {
        this.metadataRepository = new MetadataRepository();
    }

    public void addMetadata(BaseMetadata metadata) {
        this.metadataRepository.addMetadata(metadata);
    }

    public void deleteMetadata(BaseMetadata metadata) {
        this.metadataRepository.deleteMetadata(metadata);
    }

    public class MetadataRepository {
        private final List<BaseMetadata> metadata;

        MetadataRepository() {
            this.metadata = new ArrayList<>();
        }

        void addMetadata(BaseMetadata metadata) {
            this.metadata.add(metadata);
        }

        void deleteMetadata(BaseMetadata metadata) {
            this.metadata.remove(metadata);
        }
    }
}
