package core.processingchain.events.pool;

import core.processingchain.events.ApplicationEvent;

import java.util.List;

public class NotificationEvent extends ApplicationEvent {
    private final List<String> subscribers;

    public NotificationEvent(ApplicationEvent appEvent, List<String> subscribers, double eventTimestamp) {
        super(appEvent, eventTimestamp);
        this.subscribers = subscribers;
    }

    @Override
    public String toString() {
        return String.format("NotificationEvent app %s for %s for subscribers: %s",
                getAppId(), this.getName(), String.join(", ", subscribers));
    }
}
