package core.processingchain.events.pool;

import core.processingchain.metadata.pool.SolutionEventMetadata;
import core.processingchain.preprocessors.PPOutcome;
import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

public class HighPopularityEvent extends PopularityEvent {
    public HighPopularityEvent(int appId, Host detectingHost, PPOutcome ppOutcome,
                               SolutionEventMetadata eventMetadata, double timestamp, Content referredContent) {
        super(appId, "HighPopularityEvent", detectingHost, ppOutcome, eventMetadata, timestamp, referredContent);
    }

    @Override
    public String toString() {
        return String.format("HighPopularityEvent content %s at %s %s",
                getReferredContent().getDescription(),
                detectingHost.getTypeAsString(),
                detectingHost.getId()
        );
    }
}
