package core.processingchain.events;

import core.processingchain.metadata.pool.BaseMetadata;
import core.processingchain.metadata.pool.SolutionEventMetadata;
import core.processingchain.preprocessors.PPOutcome;
import edu.ucc.core.events.simulationevents.ObservableTestbedEvent;
import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

public class SolutionEvent {
    protected final int appId;
    protected final String name;
    protected final Host detectingHost;
    protected final PPOutcome ppOutcome;
    protected SolutionEventMetadata metadata;
    protected final double timestamp;
    private Content referredContent;

    public SolutionEvent(int appId, String name, Host detectingHost, PPOutcome ppOutcome,
                         SolutionEventMetadata solutionEventMetadata, double timestamp, Content referredContent) {
        this.appId = appId;
        this.name = name;
        this.detectingHost = detectingHost;
        this.ppOutcome = ppOutcome;
        this.metadata = solutionEventMetadata;
        this.timestamp = timestamp;
        this.referredContent = referredContent;
    }

    public Host getDetectingHost() {
        return detectingHost;
    }

    public ObservableTestbedEvent getTestbedEvent() {
        return ppOutcome.getObservableTestbedEvent();
    }

    public BaseMetadata getMetadata() {
        return metadata;
    }

    public void setMetadata(SolutionEventMetadata metadata) {
        this.metadata = metadata;
    }

    public double getTimestamp() {
        return timestamp;
    }

    public int getAppId() {
        return appId;
    }

    public PPOutcome getPpOutcome() {
        return ppOutcome;
    }

    public Content getReferredContent() {
        return referredContent;
    }

    protected void setReferredContent(Content referredContent) {
        this.referredContent = referredContent;
    }

    public String getName() {
        return name;
    }
}
