package core.processingchain.events;

import edu.ucc.entities.Data;

/**
 * This class represent the data for a SolutionEvent. Edge apps can use this class to create the data for their events.
 */
public class EventData extends Data {
    private final SolutionEvent solutionEvent;

    public EventData(long size, SolutionEvent solutionEvent, String URI) {
        super(size, solutionEvent.timestamp, false);
        this.solutionEvent = solutionEvent;
        this.setURI(URI);
    }

    @Override
    public String toString() {
        return "Data for event " + solutionEvent.toString() + " (appId:" + solutionEvent.getAppId() + ") ";
    }

    @Override
    public String getDescription() {
        return toString();
    }
}
