package core.processingchain.actions;

import core.app.App;
import core.processingchain.actions.exceptions.SolutionException;
import core.processingchain.actions.policies.BasePolicy;
import core.processingchain.events.SolutionEvent;
import edu.ucc.network.devices.Host;

public abstract class BaseAction {
    private final String name;

    protected BaseAction(String name) {
        this.name = name;
    }

    public abstract void execute(App app, Host localHost, SolutionEvent solutionEvent, BasePolicy policy) throws SolutionException;

    public String getName() {
        return name;
    }
}
