package core.mobility;

import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.network.devices.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobilityAnalyzer {
    private final Map<Integer, List<SpatioTemporalRecord>> mobility;
    private final MobilityPredictor mobilityPredictor;

    public MobilityAnalyzer() {
        mobility = new HashMap<>();
        mobilityPredictor = new MobilityPredictor(mobility);
    }

    public void onReportedMovement(Host host, HandoverEvent handoverEvent) {
        if (!handoverEvent.isIntraHandover()) {
            final UserEquipment ue = handoverEvent.getMovingUE();
            final int ueId = ue.getId();
            final EdgeServer targetEdgeServer = (EdgeServer) handoverEvent.getTargetBS().getParentUnit();
            int edgeServerId = targetEdgeServer.getId();
            List<SpatioTemporalRecord> spatioTemporalRecords = mobility.computeIfAbsent(ueId, k -> new ArrayList<>());
            spatioTemporalRecords.add(new SpatioTemporalRecord(ueId, edgeServerId, handoverEvent.getLocationFix()));
        }
    }

    public int predictMobilityForUserEquipment(int ueId, double timestamp) {
        return mobilityPredictor.predictMobilityForUserEquipment(ueId, timestamp);
    }

    public void registerMobilityChange(CloudUnit cloud, int ueId, int sourceBSId, int targetBSId, double timestamp) {
        // search the object in hierarchy...
        final List<Host> edgeServers = cloud.getChildrenUnits();
        BaseStation sourceBS = null, targetBS = null;
        for (var server : edgeServers) {
            EdgeServer edgeServer = (EdgeServer) server;
            final Host tmpSource = edgeServer.getChildUnit(sourceBSId);
            final Host tmpTarget = edgeServer.getChildUnit(targetBSId);
            if (null != tmpSource) {
                sourceBS = (BaseStation) tmpSource;
            }
            if (null != tmpTarget) {
                targetBS = (BaseStation) tmpTarget;
            }

        }
        final int edgeServerId = targetBS.getParentUnit().getId();
        List<SpatioTemporalRecord> spatioTemporalRecords = mobility.computeIfAbsent(ueId, k -> new ArrayList<>());
        final LocationFix fakeLocationFix = new LocationFix(0, 0, timestamp);
        spatioTemporalRecords.add(new SpatioTemporalRecord(ueId, edgeServerId, fakeLocationFix));
    }
}
