package core.control;

import edu.ucc.utils.FileConstants;

/**
 * This class models a new setting for the available storage for an app.
 * This data is supposed to be broad-casted by the cloud to children edge servers.
 */
public class StorageConfigurationEventMessageData extends MessageData {
    private final int appId;
    private final long newAvailableSpace;

    public StorageConfigurationEventMessageData(int appId, long newAvailableSpace, double timestamp) {
        super(FileConstants.KILOBYTE, timestamp);
        this.appId = appId;
        this.newAvailableSpace = newAvailableSpace;
    }

    @Override
    public String getDescription() {
        return String.format("New available space for app %s: %s", appId, newAvailableSpace);
    }

    public int getAppId() {
        return appId;
    }

    public long getNewAvailableSpace() {
        return newAvailableSpace;
    }
}
