package core.control;

import edu.ucc.network.devices.Host;
import edu.ucc.utils.FileConstants;

/**
 * This class models the data for the events to notify changes in space for apps from edge servers.
 */
public class StorageChangeEventMessageData extends MessageData {
    private final Host localHost;
    private final int appId;
    private final long dataVolume;
    private final boolean availableSpaceReduced;

    public StorageChangeEventMessageData(Host localHost, int appId, long dataVolume, boolean availableSpaceReduced, double timestamp) {
        super(FileConstants.KILOBYTE, timestamp);
        this.appId = appId;
        this.localHost = localHost;
        this.dataVolume = dataVolume;
        this.availableSpaceReduced = availableSpaceReduced;
    }

    @Override
    public String getDescription() {
        String spaceMsgPortion = availableSpaceReduced ?
                String.format("%s bytes used", dataVolume * -1) : String.format("%s bytes saved", dataVolume);
        return String.format("%s for app %s at %s %s @ %s", spaceMsgPortion, appId, localHost.getTypeAsString(), localHost.getId(), getTimestamp());
    }

    public long getDataVolume() {
        return dataVolume;
    }

    public int getAppId() {
        return appId;
    }

    public boolean isAvailableSpaceReduced() {
        return availableSpaceReduced;
    }
}
